<?php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;
$idioma = empty($_COOKIE['idioma']) ? "br" : $_COOKIE['idioma'];

$VerificarInfoSite = VerificarInfoSite();
$site_name = $VerificarInfoSite[0] ?? 'Plus TV';

try {
    $stmt = $painel_geral->prepare("SELECT status FROM captcha");
    $stmt->execute();
    $captcha_status = $stmt->fetchColumn();
} catch (PDOException $e) {
    $captcha_status = 'N'; 
}
?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($idioma); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_name) . " - " . ($_TRA['Entrar'] ?? 'Login'); ?></title>
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            overflow: hidden;
            
            /* A MÁGICA COMEÇA AQUI */
            background-image: url('background.jpg');
            background-size: cover;
            background-position: center;
            
            /* Efeito de escuridão no ambiente */
            animation: fadeInScene 1.5s ease-out;
        }

        .scene-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(ellipse at center, rgba(10,10,20,0.5) 0%, rgba(10,10,20,0.95) 100%);
        }

        @keyframes fadeInScene {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        /* O formulário agora é a "Tela da TV" */
        .tv-screen {
            position: relative; /* Mudado para relative para o z-index funcionar */
            z-index: 10;
            width: 450px;
            max-width: 90%;
            padding: 2.5rem;
            background: #0a0a0f;
            border-radius: 4px; /* Telas não são muito arredondadas */
            
            /* Efeito de brilho da tela (glow) */
            box-shadow: 0 0 15px 3px rgba(0, 255, 255, 0.1), 
                        0 0 35px 8px rgba(75, 0, 130, 0.1);
            
            animation: turnOn 1s forwards, flicker 10s infinite alternate;
            opacity: 0;
        }

        @keyframes turnOn {
            0% { transform: scale(0.8); opacity: 0; box-shadow: none; }
            50% { transform: scale(1.02); opacity: 0.8; }
            100% { transform: scale(1); opacity: 1; }
        }

        @keyframes flicker {
            0%, 100% { box-shadow: 0 0 15px 3px rgba(0, 255, 255, 0.1), 0 0 35px 8px rgba(75, 0, 130, 0.1); }
            50% { box-shadow: 0 0 20px 4px rgba(0, 255, 255, 0.15), 0 0 45px 10px rgba(75, 0, 130, 0.15); }
        }

        .logo-container {
            text-align: center;
            margin-bottom: 2.5rem;
        }

        .logo-container img {
            max-width: 150px;
            height: auto;
        }
        
        .input-group {
            position: relative;
            margin-bottom: 2rem;
        }

        /* Inputs com design futurista (apenas linha) */
        .form-control {
            width: 100%;
            padding: 10px 0;
            background: transparent;
            border: none;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            color: #ffffff;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.4);
            font-weight: 300;
        }
        
        .form-control:focus {
            outline: none;
            border-bottom-color: #00ffff; /* Cor ciano ao focar */
        }
        
        #status-message {
            text-align: center;
            padding: 0.5rem;
            margin-bottom: 1.5rem;
            color: #ff4d4d;
            font-size: 0.9rem;
            display: none;
        }
        
        .captcha-group {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        #captcha-image {
            border-radius: 4px;
            margin-bottom: 0.75rem;
            border: 1px solid rgba(0, 255, 255, 0.3);
        }

        #refresh-captcha {
            color: #00ffff;
            text-decoration: none;
            font-size: 0.8rem;
            cursor: pointer;
            text-transform: uppercase;
        }
        
        /* Botão como um "Play" da interface */
        .btn-submit {
            width: 100%;
            padding: 14px;
            border-radius: 4px;
            border: 1px solid #00ffff;
            background: transparent;
            color: #00ffff;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-submit:hover:not(:disabled) {
            background: #00ffff;
            color: #0a0a0f;
            box-shadow: 0 0 20px rgba(0, 255, 255, 0.5);
        }
        
        .btn-submit:disabled {
            opacity: 0.4;
            cursor: not-allowed;
        }
    </style>
</head>
<body>
    <div class="scene-overlay"></div>

    <div class="tv-screen">
        <div class="logo-container">
            <img src="logo.png" alt="Logo <?php echo htmlspecialchars($site_name); ?>">
        </div>

        <form id="login-form" method="POST" action="validar-login.php">
            <div id="status-message"></div>

            <div class="input-group">
                <input type="text" name="usuario" class="form-control" placeholder="<?php echo $_TRA['Usuario'] ?? 'Usuário'; ?>" required>
            </div>
            
            <div class="input-group">
                <input type="password" name="senha" class="form-control" placeholder="<?php echo $_TRA['Senha'] ?? 'Senha'; ?>" required>
            </div>

            <?php if ($captcha_status == "S"): ?>
                <div class="captcha-group">
                    <div id="captcha-image">
                        <?php include "CaptchaImg.php"; ?>
                    </div><br>
                    <a id="refresh-captcha" role="button"><?php echo $_TRA['NovoCaptcha'] ?? 'Gerar Novo Código'; ?></a>
                </div>
                <div class="input-group">
                    <input type="text" name="captcha" class="form-control" placeholder="<?php echo $_TRA['DigiteCaptcha'] ?? 'Digite o código'; ?>" required>
                </div>
            <?php endif; ?>

            <button type="submit" id="submit-button" class="btn-submit">
                <?php echo $_TRA['Entrar'] ?? 'Acessar'; ?>
            </button>
        </form>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <div id="temp-response" style="display:none;"></div>

    <script>
    $(document).ready(function() {
        // Lógica de AJAX para login (permanece a mesma, é robusta)
        const form = $('#login-form');
        const submitButton = $('#submit-button');
        const statusMessage = $('#status-message');
        const originalButtonText = submitButton.html();

        form.on('submit', function(e) {
            e.preventDefault();
            statusMessage.hide();
            submitButton.prop('disabled', true).text('Conectando...');

            $.post($(this).attr('action'), $(this).serialize())
                .done(function(response) {
                    $('#temp-response').html(response);
                    if ($('#temp-response').find("script:contains('window.location.href = \"index.php\"')").length > 0) {
                        window.location.href = "index.php";
                    } else {
                        const errorMessage = $('#temp-response').text().trim() || 'Erro desconhecido.';
                        statusMessage.text(errorMessage).show();
                        resetButton();
                        <?php if ($captcha_status == "S"): ?>
                        refreshCaptcha();
                        <?php endif; ?>
                    }
                })
                .fail(function() {
                    statusMessage.text('Falha na conexão. Tente novamente.').show();
                    resetButton();
                });
        });

        <?php if ($captcha_status == "S"): ?>
        const refreshCaptchaLink = $('#refresh-captcha');
        const captchaImage = $('#captcha-image');

        function refreshCaptcha() {
            captchaImage.css('opacity', 0.5);
            $.post('CaptchaImg.php', function(data) {
                captchaImage.html(data).css('opacity', 1);
            });
        }
        refreshCaptchaLink.on('click', function(e) { e.preventDefault(); refreshCaptcha(); });
        <?php endif; ?>

        function resetButton() {
            submitButton.prop('disabled', false).html(originalButtonText);
        }
    });
    </script>
</body>
</html>