<?php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;
$idioma = empty($_COOKIE['idioma']) ? "br" : $_COOKIE['idioma'];

$VerificarInfoSite = VerificarInfoSite();
$site_name = $VerificarInfoSite[0] ?? 'Plus TV'; // Nome padrão caso a função falhe

// Lógica do Captcha
try {
    $stmt = $painel_geral->prepare("SELECT status FROM captcha");
    $stmt->execute();
    $captcha_status = $stmt->fetchColumn();
} catch (PDOException $e) {
    $captcha_status = 'N'; 
}
?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($idioma); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_name) . " - " . ($_TRA['Entrar'] ?? 'Login'); ?></title>
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">

    <style>
        :root {
            --background-dark: #121212;
            --card-dark: #1e1e1e;
            --text-primary: #ffffff;
            --text-secondary: #a0a0a0;
            --border-color: #333333;
            --primary-accent: #ffffff;
            --primary-accent-hover: #e0e0e0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-dark);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 1rem;
        }

        .login-card {
            width: 100%;
            max-width: 400px;
            background-color: var(--card-dark);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 2.5rem;
            animation: fadeIn 0.6s ease-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo-container img {
            max-width: 180px;
            height: auto;
        }

        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .login-header h1 {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--text-primary);
        }

        .login-header p {
            color: var(--text-secondary);
            font-size: 0.9rem;
        }

        .input-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-secondary);
        }

        .form-control {
            width: 100%;
            padding: 12px 12px 12px 45px;
            background-color: var(--background-dark);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            color: var(--text-primary);
            font-size: 1rem;
            transition: border-color 0.3s, box-shadow 0.3s;
        }

        .form-control::placeholder {
            color: var(--text-secondary);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-accent);
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
        }

        .captcha-group {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        
        #captcha-image {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            margin-bottom: 0.75rem;
        }

        #refresh-captcha {
            color: var(--text-secondary);
            text-decoration: none;
            font-size: 0.9rem;
            cursor: pointer;
            transition: color 0.3s;
        }

        #refresh-captcha:hover {
            color: var(--text-primary);
        }
        
        #status-message {
            padding: 0.75rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            text-align: center;
            font-size: 0.9rem;
            font-weight: 500;
            display: none;
            background-color: #ff4d4d20;
            color: #ff4d4d;
            border: 1px solid #ff4d4d50;
        }
        
        .btn-submit {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 8px;
            background-color: var(--primary-accent);
            color: var(--background-dark);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .btn-submit:hover:not(:disabled) {
            background-color: var(--primary-accent-hover);
        }
        
        .btn-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
    </style>
</head>
<body>

    <div class="login-card">
        
        <div class="logo-container">
            <img src="logo.png" alt="Logo <?php echo htmlspecialchars($site_name); ?>">
        </div>

        <div class="login-header">
            <h1><?php echo $_TRA['SBV'] ?? 'Seja Bem-Vindo'; ?></h1>
            <p><?php echo $_TRA['Entrar'] ?? 'Faça login para continuar'; ?></p>
        </div>

        <form id="login-form" method="POST" action="validar-login.php">
            
            <div id="status-message"></div>

            <div class="input-group">
                <input type="text" name="usuario" id="usuario" class="form-control" placeholder="<?php echo $_TRA['Usuario'] ?? 'Usuário'; ?>" required>
                <i class="fa-solid fa-user"></i>
            </div>
            
            <div class="input-group">
                <input type="password" name="senha" id="senha" class="form-control" placeholder="<?php echo $_TRA['Senha'] ?? 'Senha'; ?>" required>
                <i class="fa-solid fa-lock"></i>
            </div>

            <?php if ($captcha_status == "S"): ?>
                <div class="captcha-group">
                    <div id="captcha-image">
                        <?php include "CaptchaImg.php"; ?>
                    </div><br>
                    <a id="refresh-captcha" role="button"><?php echo $_TRA['NovoCaptcha'] ?? 'Não consegue ler? Tente outro.'; ?></a>
                </div>
                <div class="input-group">
                    <input type="text" name="captcha" id="captcha" class="form-control" placeholder="<?php echo $_TRA['DigiteCaptcha'] ?? 'Digite os caracteres'; ?>" required>
                    <i class="fa-solid fa-key"></i>
                </div>
            <?php endif; ?>

            <button type="submit" id="submit-button" class="btn-submit">
                <?php echo $_TRA['Entrar'] ?? 'Entrar'; ?>
            </button>
        </form>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <div id="temp-response" style="display:none;"></div>

    <script>
    $(document).ready(function() {
        const form = $('#login-form');
        const submitButton = $('#submit-button');
        const statusMessage = $('#status-message');
        const originalButtonText = submitButton.html();

        // Submissão do Formulário
        form.on('submit', function(e) {
            e.preventDefault();
            
            statusMessage.hide();
            submitButton.prop('disabled', true).text('Validando...');

            $.post($(this).attr('action'), $(this).serialize())
                .done(function(response) {
                    $('#temp-response').html(response);
                    
                    // Verifica se a resposta contém o script de redirecionamento
                    if ($('#temp-response').find("script:contains('window.location.href = \"index.php\"')").length > 0) {
                        // Sucesso
                        window.location.href = "index.php";
                    } else {
                        // Erro
                        const errorMessage = $('#temp-response').text().trim() || 'Erro desconhecido.';
                        statusMessage.text(errorMessage).show();
                        resetButton();
                        <?php if ($captcha_status == "S"): ?>
                        refreshCaptcha();
                        <?php endif; ?>
                    }
                })
                .fail(function() {
                    statusMessage.text('Erro de conexão. Verifique sua rede.').show();
                    resetButton();
                });
        });

        // Atualização do Captcha
        <?php if ($captcha_status == "S"): ?>
        const refreshCaptchaLink = $('#refresh-captcha');
        const captchaImage = $('#captcha-image');

        function refreshCaptcha() {
            captchaImage.css('opacity', 0.5);
            $.post('CaptchaImg.php', function(data) {
                captchaImage.html(data).css('opacity', 1);
                $('#captcha').val('').focus();
            });
        }

        refreshCaptchaLink.on('click', function(e) {
            e.preventDefault();
            refreshCaptcha();
        });
        <?php endif; ?>

        // Função para resetar o botão
        function resetButton() {
            submitButton.prop('disabled', false).html(originalButtonText);
        }
    });
    </script>
</body>
</html>