<?php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;
$idioma = empty($_COOKIE['idioma']) ? "br" : $_COOKIE['idioma'];

$VerificarInfoSite = VerificarInfoSite();
$site_name = $VerificarInfoSite[0] ?? 'Plus TV';

try {
    $stmt = $painel_geral->prepare("SELECT status FROM captcha");
    $stmt->execute();
    $captcha_status = $stmt->fetchColumn();
} catch (PDOException $e) {
    $captcha_status = 'N'; 
}
?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($idioma); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($site_name) . " - " . ($_TRA['Entrar'] ?? 'Login'); ?></title>
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 1rem;
            overflow: hidden; /* Impede barras de rolagem do fundo animado */
            background: #1a1a2e; /* Cor de fundo sólida para fallback */
        }

        /* Fundo Animado com Gradiente */
        body::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, #4b0082, #ff00ff, #00ffff, #4b0082);
            z-index: -1;
            transform: translate(-50%, -50%);
            animation: background-pan 20s linear infinite;
        }

        @keyframes background-pan {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }

        .login-card {
            width: 100%;
            max-width: 400px;
            padding: 2.5rem;
            
            /* Efeito Glassmorphism */
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px); /* Suporte para Safari */
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 16px;
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);

            color: #ffffff;
            animation: fadeIn 0.6s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .logo-container {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo-container img {
            max-width: 180px;
            height: auto;
            filter: drop-shadow(0 0 15px rgba(255, 255, 255, 0.2));
        }

        .login-header h1 {
            font-size: 1.5rem;
            font-weight: 600;
            text-align: center;
            margin-bottom: 2rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        .input-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.6);
        }

        .form-control {
            width: 100%;
            padding: 12px 12px 12px 45px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            color: #ffffff;
            font-size: 1rem;
            transition: all 0.3s;
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.6);
        }

        .form-control:focus {
            outline: none;
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.5);
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
        }

        .captcha-group {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        
        #captcha-image {
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            margin-bottom: 0.75rem;
        }

        #refresh-captcha {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-size: 0.9rem;
            cursor: pointer;
            transition: color 0.3s;
        }

        #refresh-captcha:hover {
            color: #ffffff;
        }
        
        #status-message {
            padding: 0.75rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            text-align: center;
            font-size: 0.9rem;
            font-weight: 500;
            display: none;
            background-color: rgba(255, 77, 77, 0.2);
            color: #ffcccc;
            border: 1px solid rgba(255, 77, 77, 0.4);
        }
        
        .btn-submit {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 8px;
            color: #1a1a2e;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            background: linear-gradient(45deg, #e0e0e0, #ffffff);
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        .btn-submit:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.3);
        }
        
        .btn-submit:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
    </style>
</head>
<body>

    <div class="login-card">
        
        <div class="logo-container">
            <img src="logo.png" alt="Logo <?php echo htmlspecialchars($site_name); ?>">
        </div>

        <div class="login-header">
            <h1><?php echo $_TRA['SBV'] ?? 'Seja Bem-Vindo'; ?></h1>
        </div>

        <form id="login-form" method="POST" action="validar-login.php">
            
            <div id="status-message"></div>

            <div class="input-group">
                <input type="text" name="usuario" id="usuario" class="form-control" placeholder="<?php echo $_TRA['Usuario'] ?? 'Usuário'; ?>" required>
                <i class="fa-solid fa-user"></i>
            </div>
            
            <div class="input-group">
                <input type="password" name="senha" id="senha" class="form-control" placeholder="<?php echo $_TRA['Senha'] ?? 'Senha'; ?>" required>
                <i class="fa-solid fa-lock"></i>
            </div>

            <?php if ($captcha_status == "S"): ?>
                <div class="captcha-group">
                    <div id="captcha-image">
                        <?php include "CaptchaImg.php"; ?>
                    </div><br>
                    <a id="refresh-captcha" role="button"><?php echo $_TRA['NovoCaptcha'] ?? 'Tente outro'; ?></a>
                </div>
                <div class="input-group">
                    <input type="text" name="captcha" id="captcha" class="form-control" placeholder="<?php echo $_TRA['DigiteCaptcha'] ?? 'Digite os caracteres'; ?>" required>
                    <i class="fa-solid fa-key"></i>
                </div>
            <?php endif; ?>

            <button type="submit" id="submit-button" class="btn-submit">
                <?php echo $_TRA['Entrar'] ?? 'Entrar'; ?>
            </button>
        </form>
    </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <div id="temp-response" style="display:none;"></div>

    <script>
    $(document).ready(function() {
        const form = $('#login-form');
        const submitButton = $('#submit-button');
        const statusMessage = $('#status-message');
        const originalButtonText = submitButton.html();

        form.on('submit', function(e) {
            e.preventDefault();
            
            statusMessage.hide();
            submitButton.prop('disabled', true).text('Validando...');

            $.post($(this).attr('action'), $(this).serialize())
                .done(function(response) {
                    $('#temp-response').html(response);
                    
                    if ($('#temp-response').find("script:contains('window.location.href = \"index.php\"')").length > 0) {
                        window.location.href = "index.php";
                    } else {
                        const errorMessage = $('#temp-response').text().trim() || 'Erro desconhecido.';
                        statusMessage.text(errorMessage).show();
                        resetButton();
                        <?php if ($captcha_status == "S"): ?>
                        refreshCaptcha();
                        <?php endif; ?>
                    }
                })
                .fail(function() {
                    statusMessage.text('Erro de conexão. Verifique sua rede.').show();
                    resetButton();
                });
        });

        <?php if ($captcha_status == "S"): ?>
        const refreshCaptchaLink = $('#refresh-captcha');
        const captchaImage = $('#captcha-image');

        function refreshCaptcha() {
            captchaImage.css('opacity', 0.5);
            $.post('CaptchaImg.php', function(data) {
                captchaImage.html(data).css('opacity', 1);
                $('#captcha').val('').focus();
            });
        }

        refreshCaptchaLink.on('click', function(e) {
            e.preventDefault();
            refreshCaptcha();
        });
        <?php endif; ?>

        function resetButton() {
            submitButton.prop('disabled', false).html(originalButtonText);
        }
    });
    </script>
</body>
</html>