<?php
// PHP Inclusions and Setup from original login.php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;
$idioma = empty($_COOKIE['idioma']) ? "br" : $_COOKIE['idioma'];

$VerificarInfoSite = VerificarInfoSite();

// Database check for Captcha status
$SQL = "SELECT status FROM captcha";
$SQL = $painel_geral->prepare($SQL);
$SQL->execute();
$Ln = $SQL->fetch();
$captcha = $Ln['status'];
?>
<!DOCTYPE html>
<html lang="<?php echo $idioma; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $VerificarInfoSite[0]. " - " .$_TRA['Entrar']; ?></title>
    <link rel="icon" href="favicon.ico" type="image/x-icon" />
    <meta name="robots" content="noindex">
    <meta name="description" content="Entre com seu usuário e senha."/>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* CSS Copiado do tema moderno */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 420px;
            width: 100%;
            animation: slideUp 0.8s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .header-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
        }

        .header-section::before {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 20px solid transparent;
            border-right: 20px solid transparent;
            border-top: 20px solid #764ba2;
        }

        .logo {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .subtitle {
            font-size: 0.9rem;
            opacity: 0.9;
            margin-bottom: 15px;
        }

        .welcome-badge {
            background: rgba(255,255,255,0.2);
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 0.85rem;
            font-weight: 500;
            display: inline-block;
        }

        .form-section {
            padding: 40px 30px;
        }

        .login-title {
            text-align: center;
            margin-bottom: 30px;
            color: #333;
        }

        .login-title h3 {
            font-weight: 600;
            margin-bottom: 8px;
        }

        .login-title p {
            color: #666;
            font-size: 0.9rem;
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        .form-label {
            color: #555;
            font-weight: 500;
            margin-bottom: 8px;
            display: block;
            font-size: 0.9rem;
        }

        .form-control {
            border: 2px solid #e1e5e9;
            border-radius: 12px;
            padding: 15px 20px 15px 50px; /* Ajustado para ícone */
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #f8f9fa;
            width: 100%;
        }

        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            background: white;
            outline: none;
        }

        .input-icon {
            position: absolute;
            left: 18px;
            top: 38px; /* Ajustado para alinhar com o input */
            color: #adb5bd;
            font-size: 1.1rem;
        }

        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 12px;
            padding: 15px;
            color: white;
            font-weight: 600;
            font-size: 1.1rem;
            width: 100%;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            cursor: pointer;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .captcha-section {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            margin-bottom: 20px;
            border: 2px solid #e1e5e9;
        }

        .captcha-section img {
            border-radius: 8px;
            margin-bottom: 15px;
        }

        .btn-refresh-captcha {
            background: none;
            border: 2px solid #667eea;
            color: #667eea;
            border-radius: 8px;
            padding: 8px 15px;
            font-size: 0.85rem;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .btn-refresh-captcha:hover {
            background: #667eea;
            color: white;
        }

        .security-badge {
            text-align: center;
            margin-top: 20px;
            color: #6c757d;
            font-size: 0.8rem;
        }

        .security-badge i {
            color: #28a745;
            margin-right: 5px;
        }

        .loading {
            display: none;
        }

        .loading .spinner-border {
            width: 1.2rem;
            height: 1.2rem;
        }

        .forgot-password {
            text-align: center;
            margin-top: 20px;
        }

        .forgot-password a {
            color: #667eea;
            text-decoration: none;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .forgot-password a:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        .alert {
            border-radius: 12px;
            border: none;
            padding: 15px 20px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        /* Ajustes para o botão de visualização de senha */
        .password-group {
            position: relative;
        }
        .viewPassword {
            position: absolute;
            right: 1px;
            top: 1px;
            height: 98%;
            width: 50px;
            border-radius: 0 12px 12px 0;
            background: #e1e5e9; /* Cor de fundo mais neutra */
            color: #555;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 10;
            transition: background 0.3s ease;
        }
        .viewPassword:hover {
            background: #d1d5d9;
        }
        .form-control.inputPassword {
             padding-right: 60px !important; /* Mais espaço para o botão */
        }
        .password-group .input-icon {
            top: 1px;
            bottom: 0;
            height: 100%;
            display: flex;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="header-section">
            <div class="logo"><?php echo $VerificarInfoSite[0]; ?></div>
            <div class="subtitle"><?php echo $VerificarInfoSite[1]; ?></div>
            <div class="welcome-badge">
                <i class="fas fa-user-shield"></i> <?php echo $_TRA['SBV']; ?>
            </div>
        </div>

        <div class="form-section">
            <div class="login-title">
                <h3><i class="fas fa-sign-in-alt"></i> <?php echo $_TRA['Entrar']; ?></h3>
                <p>Acesse sua conta para continuar</p>
            </div>

            <form id="FormLogin" name="FormLogin" class="FormLogin form-horizontal" method="POST" action="javascript:void(0)">

                <div class="form-group">
                    <label class="form-label"><?php echo $_TRA['Usuario']; ?></label>
                    <input type="text" name="usuario" id="usuario" class="form-control" placeholder="<?php echo $_TRA['Usuario']; ?>" required autocomplete="username">
                    <i class="fas fa-user input-icon"></i>
                </div>

                <div class="form-group password-group">
                    <label class="form-label"><?php echo $_TRA['Senha']; ?></label>
                    <input type="password" name="senha" id="senha" class="form-control inputPassword" placeholder="<?php echo $_TRA['Senha']; ?>" required autocomplete="current-password">
                    <i class="fas fa-lock input-icon"></i>
                    <span class="viewPassword">
                        <i class="fa fa-eye" aria-hidden="true"></i>
                        <i class="fa fa-eye-slash" aria-hidden="true" style="display: none;"></i>
                    </span>
                </div>

                <?php
                // Se o CAPTCHA estiver ativado
                if($captcha == "S"){
                ?>
                <div class="captcha-section">
                    <center>
                        <div id="StatusCaptcha">
                            <?php include ("CaptchaImg.php"); // Inclui a imagem do Captcha ?>
                        </div>
                    </center>
                    <div class="text-end mt-2">
                        <button type="button" class="btn-refresh-captcha" onClick="NovoCaptcha()">
                            <i class="fas fa-sync-alt"></i> Novo Captcha
                        </button>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Captcha</label>
                    <input type="text" name="captcha" id="captcha" class="form-control" placeholder="Digite o Captcha" required>
                    <i class="fas fa-shield-alt input-icon"></i>
                </div>
                <?php
                }
                ?>

                <button type="submit" class="btn-login" onClick="FazerLoginIPTV(); return false;">
                    <span class="btn-text">
                        <i class="fas fa-sign-in-alt"></i> <?php echo $_TRA['Entrar']; ?>
                    </span>
                    <span class="loading">
                        <div class="spinner-border text-light" role="status"></div> Entrando...
                    </span>
                </button>

                <div class="forgot-password">
                    <a href="#" onclick="alert('Entre em contato com o administrador');">
                        <i class="fas fa-question-circle"></i> Esqueceu sua senha?
                    </a>
                </div>

                <div class="security-badge">
                    <i class="fas fa-shield-alt"></i> Conexão segura e criptografada
                </div>
                
                <div class="login-footer text-center mt-4">
                    <div class="text-muted" style="font-size: 0.8rem;">
                        &copy; <?php echo date("Y");?> <?php echo $VerificarInfoSite[0]; ?>
                    </div>
                </div>

            </form>
        </div>
    </div>

    <div id="StatusGeral"></div>
    <div id="StatusLogin" style="display:none;"></div> <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript" src="js/plugins/jquery/jquery.min.js"></script>
    <script type="text/javascript" src="js/plugins/bootstrap/bootstrap.min.js"></script>
    <script type="text/javascript" src="js/plugins.js"></script>
    <script type="text/javascript" src="js/actions.js"></script>

    <script>
        // Ver Senha - Adaptado para o novo layout
        $('.viewPassword').click(function() {

            var passwordField = $('.inputPassword');
            var eyeIcon = $(this).find('.fa-eye');
            var slashIcon = $(this).find('.fa-eye-slash');

            if(passwordField.attr('type') === 'password') {
                passwordField.attr('type', 'text');
                eyeIcon.hide();
                slashIcon.show();

            } else {
                passwordField.attr('type', 'password');
                slashIcon.hide();
                eyeIcon.show();
            }
        });

        <?php
        if($captcha == "S"){
        ?>
        function NovoCaptcha(){
            // Mostrar loading (opcionalmente) e atualizar
            panel_refresh($(".login-container"));

            $.post('CaptchaImg.php', function(resposta) {
                setTimeout(function() {
                    panel_refresh($(".login-container"));
                    // Insere o novo Captcha
                    $("#StatusCaptcha").html(resposta);
                }, 500); // Atraso para efeito visual
            });
        }
        <?php
        }
        ?>

        function FazerLoginIPTV(){
            var Data = $(".FormLogin").serialize();

            // Mostrar loading
            $(".btn-text").hide();
            $(".loading").show();
            $(".btn-login").prop('disabled', true);

            // Inicia o efeito de refresh/loading
            panel_refresh($(".login-container"));

            // Requisição AJAX
            $.post('validar-login.php', Data, function(resposta) {
                // Esconde o efeito de refresh/loading
                setTimeout(function() {
                    panel_refresh($(".login-container"));
                }, 500);

                // Esconder loading
                $(".btn-text").show();
                $(".loading").hide();
                $(".btn-login").prop('disabled', false);

                // Exibe a resposta do servidor
                $("#StatusGeral").html('');
                $("#StatusGeral").append(resposta);
            });
        }

        // Enter key submit
        $(document).keypress(function(e) {
            if(e.which == 13) {
                // Verifica se o input de Captcha está ativo e focado.
                // Se sim, o Enter deve disparar o login
                if( $('#captcha').length && $('#captcha').is(':focus') ) {
                     FazerLoginIPTV();
                     return false;
                } else if( !$('#captcha').length ) {
                     // Se não tem Captcha, sempre faz login
                     FazerLoginIPTV();
                     return false;
                }
            }
        });
    </script>
</body>
</html>