<?php
// exportar_whatsapp.php
include("conexao.php"); // Sua conexão
include_once("functions.php"); // Suas funções
session_start();

// Protege a página para garantir que apenas usuários logados possam usar
if(ProtegePag() == false){
	header('Content-Type: application/json');
	echo json_encode(['success' => false, 'message' => 'Acesso negado.']);
	exit();
}

// Pega o ID do usuário enviado pelo JavaScript
$usuarioId = isset($_POST['id']) ? intval($_POST['id']) : 0;

if ($usuarioId > 0) {
    global $painel_geral; // Sua variável de conexão PDO

    try {
        // 1. BUSCAR DADOS NA TABELA 'usuario' (do banco teste_user)
        // Note que o PDO já deve estar conectado ao banco de dados correto
        // conforme seu arquivo conexao.php
        $sqlUser = "SELECT usuario, senha, perfil FROM usuario WHERE id = :id";
        $stmtUser = $painel_geral->prepare($sqlUser);
        $stmtUser->bindParam(':id', $usuarioId, PDO::PARAM_INT);
        $stmtUser->execute();
        $dadosUsuario = $stmtUser->fetch(PDO::FETCH_ASSOC);

        if ($dadosUsuario) {
            // Extrai o primeiro nome do perfil do campo de texto. Ex: de '[vivo][net]' pega 'vivo'
            preg_match('/\[(.*?)\]/', $dadosUsuario['perfil'], $matches);
            $nomePerfil = isset($matches[1]) ? $matches[1] : null;

            if ($nomePerfil) {
                // 2. BUSCAR URL E PORTA NA TABELA 'perfil' (do banco teste_geral)
                $sqlPerfil = "SELECT url, porta FROM perfil WHERE nome = :nome";
                $stmtPerfil = $painel_geral->prepare($sqlPerfil);
                $stmtPerfil->bindParam(':nome', $nomePerfil, PDO::PARAM_STR);
                $stmtPerfil->execute();
                $dadosPerfil = $stmtPerfil->fetch(PDO::FETCH_ASSOC);

                if ($dadosPerfil) {
                    $login = $dadosUsuario['usuario'];
                    $senha = $dadosUsuario['senha'];
                    $url = $dadosPerfil['url'];
                    $porta = $dadosPerfil['porta'];

                    // 3. MONTAR A MENSAGEM FINAL
                    $mensagem = " segue os dados de acesso:\n\n" .
                                " Usuário: *{$login}*\n" .
                                " Senha: *{$senha}*\n\n" .
                                " URL: `{$url}:{$porta}`\n\n" .
                                "Obrigado!";
                    
                    $mensagemCodificada = urlencode($mensagem);
                    $urlWhatsapp = "https://api.whatsapp.com/send?text=" . $mensagemCodificada;

                    // Retorna sucesso e a URL para o JavaScript
                    echo json_encode(['success' => true, 'url' => $urlWhatsapp]);

                } else {
                    echo json_encode(['success' => false, 'message' => 'URL e Porta não encontradas para o perfil: ' . $nomePerfil]);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Nenhum perfil válido encontrado para este usuário.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Usuário não encontrado.']);
        }
    } catch (PDOException $e) {
        // Em caso de erro de banco de dados
        echo json_encode(['success' => false, 'message' => 'Erro de banco de dados: ' . $e->getMessage()]);
    }

} else {
    echo json_encode(['success' => false, 'message' => 'ID de usuário inválido.']);
}

// Define o cabeçalho como JSON no final para garantir
header('Content-Type: application/json');
?>