<?php
// --- SCRIPT DE DIAGNÓSTICO AVANÇADO ---

// Função para escrever no log
function write_log($message) {
    $log_file = 'log_chatbot.txt';
    $current_time = date('Y-m-d H:i:s');
    $log_entry = "[" . $current_time . "] " . $message . "\n";
    file_put_contents($log_file, $log_entry, FILE_APPEND);
}

// Inicia o log
write_log("--- INÍCIO DA REQUISIÇÃO ---");

// Inclui os arquivos do painel
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA, $painel_user, $painel_acessos;

write_log("Arquivos do painel incluídos com sucesso.");

// Resposta padrão
$resposta_final = "Ocorreu um erro desconhecido.";

// VERIFICAÇÃO DE SEGURANÇA
$chave_recebida = isset($_GET['key']) ? $_GET['key'] : '';
write_log("Chave recebida: " . $chave_recebida);

if (empty($chave_recebida)) {
    write_log("ERRO: Chave de acesso não fornecida.");
    echo json_encode(["reply" => "ERRO: Chave de acesso não fornecida."]);
    exit();
}

// Procura o revendedor pela chave
$grupo = "N";
$sql_rev = "SELECT CadUser FROM rev WHERE chatbot_key = :chatbot_key AND grupo = :grupo";
$stmt_rev = $painel_acessos->prepare($sql_rev);
$stmt_rev->execute([':chatbot_key' => $chave_recebida, ':grupo' => $grupo]);
$revendedor = $stmt_rev->fetch(PDO::FETCH_ASSOC);

if (!$revendedor) {
    write_log("ERRO: Revendedor não encontrado para a chave fornecida.");
    echo json_encode(["reply" => "ERRO: Acesso não autorizado. Chave inválida."]);
    exit();
}
$CadUser = $revendedor['CadUser'];
write_log("Revendedor encontrado. CadUser: " . $CadUser);

// PROCESSAMENTO DA MENSAGEM
$mensagem_recebida = isset($_REQUEST['query']) ? strtolower(trim($_REQUEST['query'])) : 'teste'; // Força 'teste' para diagnóstico
write_log("Mensagem recebida: " . $mensagem_recebida);

// LÓGICA DO CHATBOT
$VerTeste = VerTeste($CadUser);
if ($VerTeste[0] == 1) {
    write_log("Permissão para criar teste: SIM. Duração: " . $VerTeste[1] . " dias.");

    $sql_perfil = "SELECT valorcsp FROM perfil WHERE CadUser = :CadUser LIMIT 1";
    $stmt_perfil = $painel_acessos->prepare($sql_perfil);
    $stmt_perfil->execute([':CadUser' => $CadUser]);
    $perfil_result = $stmt_perfil->fetch(PDO::FETCH_ASSOC);

    if (!$perfil_result) {
        $resposta_final = "❌ Desculpe, não há servidores de teste configurados para este revendedor.";
        write_log("ERRO: Nenhum perfil de servidor encontrado para o CadUser: " . $CadUser);
    } else {
        $Operadora = $perfil_result['valorcsp'];
        write_log("Perfil de servidor encontrado: " . $Operadora);
        
        // Dados do teste
        $nome = "Teste Chatbot " . date('H:i');
        $email = "teste_chatbot_" . time() . "@chatbot.com";
        $celular = isset($_REQUEST['sender']) ? $_REQUEST['sender'] : 'N/A';
        $tempo = $VerTeste[1];
        $Premium = time() + (3600 * 24 * $tempo);
        $DataAtual = date('Y-m-d H:i:s');
        $gerarNums = gerarNums(5, 0, 9, $email);
        $usuario = $gerarNums[0];
        $senha = $gerarNums[1];

        write_log("Dados gerados - Usuário: " . $usuario . " | Senha: " . $senha);

        try {
            $SQL = "INSERT INTO teste (CadUser, nome, usuario, senha, email, conexao, perfil, data_cadastro, data_premio, celular) VALUES (:CadUser, :nome, :usuario, :senha, :email, 1, :perfil, :data_cadastro, :data_premio, :celular)";
            write_log("Preparando para executar SQL: " . $SQL);
            $stmt_insert = $painel_user->prepare($SQL);
            
            $stmt_insert->execute([
                ':CadUser' => $CadUser,
                ':nome' => $nome,
                ':usuario' => $usuario,
                ':senha' => $senha,
                ':email' => $email,
                ':perfil' => $Operadora,
                ':data_cadastro' => $DataAtual,
                ':data_premio' => $Premium,
                ':celular' => $celular
            ]);

            write_log("SUCESSO: INSERT executado no banco de dados.");
            $duracao_teste = $tempo . ($tempo > 1 ? " dias" : " dia");
            $resposta_final = "✅ Seu teste foi gerado com sucesso!\n\n*Usuário:* `{$usuario}`\n*Senha:* `{$senha}`\n\n_Válido por {$duracao_teste}._";

        } catch (PDOException $e) {
            $resposta_final = "❌ Ocorreu um erro interno ao gerar seu teste.";
            write_log("!!!!!!!!!! ERRO DE BANCO DE DADOS !!!!!!!!!!");
            write_log("Mensagem do Erro: " . $e->getMessage());
        }
    }
} else {
    $resposta_final = "❌ Desculpe, a geração de testes está desativada no momento.";
    write_log("ERRO: Revendedor não tem permissão para criar testes (VerTeste[0] != 1).");
}

write_log("--- FIM DA REQUISIÇÃO --- \n\n");

// ENVIO DA RESPOSTA FINAL
header('Content-Type: application/json; charset=utf-8');
echo json_encode(["reply" => $resposta_final]);

?>